/****** Object:  StoredProcedure [dbo].[P_ATUALIZA_EST_PROD_MIX_AGD_BLOQUEIO_ALL]    Script Date: 02/26/2014 19:52:06 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_ATUALIZA_EST_PROD_MIX_AGD_BLOQUEIO_ALL]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_ATUALIZA_EST_PROD_MIX_AGD_BLOQUEIO_ALL]
GO
GO 

--Procedure para atualizao agendamento do mix bloqueio
CREATE  PROCEDURE [dbo].[P_ATUALIZA_EST_PROD_MIX_AGD_BLOQUEIO_ALL] @CD_EMP INT=1, @CD_BLOQUEIO INT=0  WITH ENCRYPTION AS  

SET NOCOUNT ON;  
DECLARE @CodigoBloqueio  INT, 
	@AtivaDesativa Tinyint;

Print 'Atualizando os bloqueio mix - Time '+ convert(varchar,getdate(),108)
--Ativar e desativar bloqueio
--EXEC P_ATUALIZA_EST_PROD_MIX_AGD_BLOQUEIO_ALL

Declare cBloqueio cursor fast_forward read_only
for	
    SELECT  
	   EST_PROD_MIX_AGD_BLOQUEIO.CD_CTR,
	   1 ATIVA_DESATIVA
    FROM 
	   EST_PROD_MIX_AGD_BLOQUEIO
    WHERE
	   EST_PROD_MIX_AGD_BLOQUEIO.STATUS IN (0,1)
	   AND CONVERT(DATE,GETDATE()) BETWEEN EST_PROD_MIX_AGD_BLOQUEIO.DT_INICIO_BLOQUEIO AND EST_PROD_MIX_AGD_BLOQUEIO.DT_FIM_BLOQUEIO
	   AND EST_PROD_MIX_AGD_BLOQUEIO.CD_CTR =  CASE WHEN @CD_BLOQUEIO > 0 THEN 
									   @CD_BLOQUEIO  
									ELSE 
									   EST_PROD_MIX_AGD_BLOQUEIO.CD_CTR 
									 END
    UNION ALL
    SELECT  
	   EST_PROD_MIX_AGD_BLOQUEIO.CD_CTR,
	   0 ATIVA_DESATIVA
    FROM 
	   EST_PROD_MIX_AGD_BLOQUEIO
    WHERE
	   EST_PROD_MIX_AGD_BLOQUEIO.STATUS IN (0,1)
	   AND EST_PROD_MIX_AGD_BLOQUEIO.DT_FIM_BLOQUEIO < CONVERT(DATE,GETDATE())
	   AND EST_PROD_MIX_AGD_BLOQUEIO.CD_CTR =  CASE WHEN @CD_BLOQUEIO > 0 THEN 
									   @CD_BLOQUEIO  
									ELSE 
									   EST_PROD_MIX_AGD_BLOQUEIO.CD_CTR 
									 END
	ORDER BY 
	   ATIVA_DESATIVA,
	   EST_PROD_MIX_AGD_BLOQUEIO.CD_CTR;


OPEN cBloqueio 
FETCH NEXT from cBloqueio  INTO @CodigoBloqueio,@AtivaDesativa 
	WHILE @@FETCH_STATUS=0
	  begin
		Print 'Analisando bloqueio ' + convert(varchar(10), @CodigoBloqueio) + ' Time '  + convert(varchar,getdate(),108);

		EXEC P_ATUALIZA_EST_PROD_MIX_AGD_BLOQUEIO @CD_EMP, @CodigoBloqueio,@AtivaDesativa ;

		FETCH NEXT from cBloqueio  INTO @CodigoBloqueio,@AtivaDesativa ;
	end

	Close cBloqueio  
	Deallocate cBloqueio;